/**
 * \file: mspin_measurement.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * MySpin Logging
 *
 * \component: MSPIN
 *
 * \author: Thilo Bjoern Fickel ICT-ADITG/SW2 tfickel@de.adit-jv.com
 *
 * \copyright: (c) 2003 - 2014 ADIT Corporation
 *
 * \history
 * 0.1 TFickel Initial version
 *
 ***********************************************************************/

#ifndef MSPIN_MEASUREMENT_H_
#define MSPIN_MEASUREMENT_H_

#ifdef PROJECTBUILD_NISSAN_LCN2
#include <adit_typedef.h>
#else
#include <adit-system/adit_typedef.h>
#endif

#include <stdlib.h>

//Enable MSPIN_ENABLE_FRAME_MEASUREMENTS as compile flag. If not possible enable it here:
//#define MSPIN_ENABLE_FRAME_MEASUREMENTS

void mspin_measure_enableFrameLatency(void);

void mspin_measure_reset(void);

void mspin_measure_startInitLayer(void);

void mspin_measure_layerManagerInitialized(void);

void mspin_measure_startNewFrame(void);

void mspin_measure_frameRequested(U8 *pBuffer, size_t bufferSize);

void mspin_measure_frameReceiveStart(void);

void mspin_measure_frameReceived(void);

void mspin_measure_frameRectCompressed(U8 frameNumber, U32 bufferSize);

void mspin_measure_frameReadyToDisplay(void);

void mspin_measure_frameRendered(void);

void mspin_measure_setDataReceived(U8 *pBuffer, size_t bufferSize);

#endif /* MSPIN_MEASUREMENT_H_ */
